#ifndef _libzkfp_h
#define _libzkfp_h
/**
*	@file		libzkfp.h
*	@brief		ӿڶ
*	@author		scar chen
*	@date		2016-04-12
*	@version	5.0
*	@par	Ȩ
*				ZKTeco
*	@par	ʷ汾			
*
*	@note
*
*/


#include "libzkfptype.h"


#ifdef __cplusplus
extern "C"
{
#endif

/**
	*	@brief	ʼ
	*	@param	:
	*		
	*	@return
	*	ֵ˵£
	*	value			|	type		|	description of value
	*	----------------|---------------|-------------------------------
	*	0				|	int			|	ɹ
	*				|	int			|	ʧ
	*	@note 
*/
ZKINTERFACE int APICALL ZKFPM_Init();

/**
	*	@brief	ͷſ
	*	@param	:
	*		
	*	@return
	*	ֵ˵£
	*	value			|	type		|	description of value
	*	----------------|---------------|-------------------------------
	*	0				|	int			|	ɹ
	*				|	int			|	ʧ
	*	@note 
*/
ZKINTERFACE int APICALL ZKFPM_Terminate();

/**
	*	@brief	ȡ豸
	*	@param	:
	*		
	*	@return
	*	ֵ˵£
	*		ǰָ豸
	*	@note 
*/
ZKINTERFACE int APICALL ZKFPM_GetDeviceCount();


/**
		*	@brief	豸
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	index			|	int			  |	[in]				|	豸
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	NULL			|	HANDLE		|	ʧ
		*				|	HANDLE		|	ɹ
		*	@note 
	*/
	ZKINTERFACE HANDLE APICALL ZKFPM_OpenDevice(int index);

	/**
		*	@brief	ر豸
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDevice			|	HANDLE		  |	[in]				|	豸ʵָ
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_CloseDevice(HANDLE hDevice);

	

	/**
		*	@brief	ò
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDevice			|	HANDLE		  |	[in]				|	豸ʵָ
		*	nParamCode		|	int			  |	[in]				|	
		*	paramValue		|	unsigned char*|	[in]				|	ֵ
		*	cbParamValue	|	unsigned int  |	[in]				|	ݳ
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_SetParameters(HANDLE hDevice, int nParamCode, unsigned char* paramValue, unsigned int cbParamValue);

	/**
		*	@brief	ȡ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDevice			|	HANDLE		  |	[in]				|	豸ʵָ
		*	nParamCode		|	int			  |	[in]				|	
		*	paramValue		|	unsigned char*|	[out]				|	ֵ
		*	cbParamValue	|	unsigned int* |	[out]				|	ݳ
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_GetParameters(HANDLE hDevice, int nParamCode, unsigned char* paramValue, unsigned int* cbParamValue);
	
	/**
		*	@brief	ȡָ(ͼ/ģ壩
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDevice			|	HANDLE		  |	[in]				|	豸ʵָ
		*	fpImage			|	unsigned char*|	[out]				|	ָͼ
		*	cbFPImage		|	unsigned int  |	[in]				|	fpImageڴС
		*	fpTemplate		|	unsigned char*|	[out]				|	ָģ
		*	cbTemplate		|	unsigned int* |	[in/out]			|	ָģ峤
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_AcquireFingerprint(HANDLE hDevice, unsigned char* fpImage, unsigned int cbFPImage, unsigned char* fpTemplate, unsigned int* cbTemplate);


	/**
		*	@brief	ȡָͼ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDevice			|	HANDLE		  |	[in]				|	豸ʵָ
		*	fpImage			|	unsigned char*|	[out]				|	ָͼ
		*	cbFPImage		|	unsigned int  |	[in]				|	fpImageڴС
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_AcquireFingerprintImage(HANDLE hDevice, unsigned char* fpImage, unsigned int cbFPImage);

	/**
		*	@brief	㷨ʵ
		*	@param	:
		*	
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	NULL			|	HANDLE		|	ʧ
		*				|	HANDLE		|	ɹ
		*	@note 
	*/
	ZKINTERFACE HANDLE APICALL ZKFPM_CreateDBCache();
	ZKINTERFACE HANDLE APICALL ZKFPM_DBInit();	//same as ZKFPM_CreateDBCache, for new version
	/**
		*	@brief	ͷ㷨ʵ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_CloseDBCache(HANDLE hDBCache);
	ZKINTERFACE int APICALL ZKFPM_DBFree(HANDLE hDBCache); //same as ZKFPM_CloseDBCache, for new version

	ZKINTERFACE int APICALL ZKFPM_DBSetParameter(HANDLE hDBCache, int nParamCode, int paramValue);
	ZKINTERFACE int APICALL ZKFPM_DBGetParameter(HANDLE hDBCache, int nParamCode, int* paramValue);


	/**
		*	@brief	3ָģϳɵǼģ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	temp1			|	unsigned char*|	[in]				|	ָģ1
		*	temp2			|	unsigned char*|	[in]				|	ָģ2
		*	temp3			|	unsigned char*|	[in]				|	ָģ3
		*	regTemp			|	unsigned char*|	[out]				|	Ǽģ
		*	cbRegTemp		|	unsigned int* |	[in/out]			|	Ǽģ峤
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_GenRegTemplate(HANDLE hDBCache, unsigned char* temp1, unsigned char* temp2, unsigned char* temp3, unsigned char* regTemp, unsigned int* cbRegTemp);
	ZKINTERFACE int APICALL ZKFPM_DBMerge(HANDLE hDBCache, unsigned char* temp1, unsigned char* temp2, unsigned char* temp3, unsigned char* regTemp, unsigned int* cbRegTemp);	//same as ZKFPM_GenRegTemplate, for new version
		
	/**
		*	@brief	ָģ嵽
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	fid				|	unsigned int  |	[in]				|	ָID
		*	fpTemplate		|	unsigned char*|	[in]				|	ָģ
		*	cbTemplate		|	unsigned int  |	[in]				|	ָģ峤
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_AddRegTemplateToDBCache(HANDLE hDBCache, unsigned int fid, unsigned char* fpTemplate, unsigned int cbTemplate);
	ZKINTERFACE int APICALL ZKFPM_DBAdd(HANDLE hDBCache, unsigned int fid, unsigned char* fpTemplate, unsigned int cbTemplate);	//same as ZKFPM_AddRegTemplateToDBCache, for new version

	/**
		*	@brief	ӻɾָģ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	fid				|	unsigned int  |	[in]				|	ָID
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_DelRegTemplateFromDBCache(HANDLE hDBCache, unsigned int fid);
	ZKINTERFACE int APICALL ZKFPM_DBDel(HANDLE hDBCache, unsigned int fid);			//same as ZKFPM_DelRegTemplateFromDBCache, for new version
	

	/**
		*	@brief	㷨
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_ClearDBCache(HANDLE hDBCache);
	ZKINTERFACE int APICALL ZKFPM_DBClear(HANDLE hDBCache);	//same as ZKFPM_ClearDBCache, for new version

	/**
		*	@brief	ȡģ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	fpCount			|	unsigned int* |	[out]				|	ָģ
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_GetDBCacheCount(HANDLE hDBCache, unsigned int* fpCount);
	ZKINTERFACE int APICALL ZKFPM_DBCount(HANDLE hDBCache, unsigned int* fpCount);	//same as ZKFPM_GetDBCacheCount, for new version


	/**
		*	@brief	ָʶ(1:N)
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	fpTemplate		|	unsigned char*|	[in]				|	ָģ
		*	cbTemplate		|	unsigned int  | [in]				|	ָģС
		*	FID				|	unsigned int* |	[out]				|	ָID
		*	score			|	unsigned int* |	[out]				|	
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_Identify(HANDLE hDBCache, unsigned char* fpTemplate, unsigned int cbTemplate, unsigned int* FID, unsigned int* score);
	ZKINTERFACE int APICALL ZKFPM_DBIdentify(HANDLE hDBCache, unsigned char* fpTemplate, unsigned int cbTemplate, unsigned int* FID, unsigned int* score);	//same as ZKFPM_Identify, for new version


	/**
		*	@brief	ȶöָ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	template1		|	unsigned char*|	[in]				|	ָģ1
		*	cbTemplate1		|	unsigned int  | [in]				|	ָģ1С
		*	template2		|	unsigned char*|	[in]				|	ָģ2
		*	cbTemplate2		|	unsigned int  | [in]				|	ָģ2С
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	>0				|	int			|	
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_MatchFinger(HANDLE hDBCache, unsigned char* template1, unsigned int cbTemplate1, unsigned char* template2, unsigned int cbTemplate2);
	ZKINTERFACE int APICALL ZKFPM_DBMatch(HANDLE hDBCache, unsigned char* template1, unsigned int cbTemplate1, unsigned char* template2, unsigned int cbTemplate2); //same as ZKFPM_MatchFinger, for new version

	/**
		*	@brief	Bitmapļȡָģ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	lpFilePathName	|	const char*   |	[in]				|	BMPͼƬ·
		*	DPI				|	unsigned int  | [in]				|	BMPͼƬDPI
		*	fpTemplate		|	unsigned char*|	[out]				|	ָģ
		*	cbTemplate		|	unsigned int* |	[in/out]			|	ģ峤
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	>0				|	int			|	
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_ExtractFromImage(HANDLE hDBCache, const char* lpFilePathName, unsigned int DPI, unsigned char* fpTemplate, unsigned int *cbTemplate);


	/**
		*	@brief	Base64ַת
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	src				|	const char*	  |	[in]				|	Base64ַ
		*	blob			|	unsigned char*|	[out]				|	ض
		*	cbBlob			|	unsigned int  |	[in]				|	blobڴС
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	>0ʾݳȣ<=0ʾʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_Base64ToBlob(const char* src, unsigned char* blob, unsigned int cbBlob);

	/**
		*	@brief	תBase64ַ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	src				|const unsigned char*|	[in]			|	
		*	cbSrc			|	unsigned int  |	[in]				|	ݳ
		*	base64Str		|	char *		  |	[out]				|	Base64ַ
		*	cbBase64str		|	unsigned int  | [int]				|	base64StrڴС
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	>0ʾݳȣ<=0ʾʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_BlobToBase64(const unsigned char* src, unsigned int cbSrc, char* base64Str, unsigned int cbBase64str);


	/**
		*	@brief	1:1ȶûָ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDBCache		|	HANDLE		  |	[in]				|	㷨ʵָ
		*	fpTemplate		|	unsigned char*|	[in]				|	ָģ
		*	cbTemplate		|	unsigned int  | [in]				|	ָģС
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	>0				|	int			|	
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_VerifyByID(HANDLE hDBCache, unsigned int fid, unsigned char* fpTemplate, unsigned int cbTemplate);

	/**
		*	@brief	ȡһⲿͼָ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	width			|	int*		  |	[out]				|	ͼ
		*	height			|	int*		  |	[out]				|	ͼ
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	ͼָ룬ZKFPM_ExtractFromImageɹȡ
		*	@note 
	*/
	ZKINTERFACE unsigned char* APICALL ZKFPM_GetLastExtractImage(int * width, int* height);


	/**
		*	@brief	ȡɼ
		*	@param	:
		*	˵±
		*	name			|	type		  |	param direction		|	description of param
		*	----------------|-----------------|---------------------|------------------------
		*	hDevice			|	HANDLE		  |	[in]				|	豸ʵָ
		*	pCapParams		|	PZKFPCapParams|	[out]				|	ɼ
		*	@return
		*	ֵ˵£
		*	value			|	type		|	description of value
		*	----------------|---------------|-------------------------------
		*	0				|	int			|	ɹ
		*				|	int			|	ʧ
		*	@note 
	*/
	ZKINTERFACE int APICALL ZKFPM_GetCaptureParams(HANDLE hDevice, PZKFPCapParams pCapParams);

	ZKINTERFACE int APICALL ZKFPM_GetCaptureParamsEx(HANDLE hDevice, int* width, int* height, int* dpi);

#ifdef __cplusplus
};
#endif


#endif	//_libzkfp_h